/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.concept.operations.CopyOperationBuilder;
import com.ur.polyscope.concept.operations.MoveOperationBuilder;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.filemanager.FileStrategy;
import com.ur.polyscope.filemanager.impl.operations.ClipboardModelSource;
import com.ur.polyscope.filemanager.impl.operations.ClipboardOperationFactory;
import com.ur.polyscope.filemanager.impl.operations.RenameOperationFactory;
import com.ur.polyscope.filemanager.impl.usb.IUSBFileOperation;
import com.ur.swing.ViewContext;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

public class FileOperations {
    private final ClipboardModelSource clipboardModelSource;
    private final ViewContext viewContext;
    private Set<FileStrategy> fileStrategies;
    private IUSBFileOperation usbFileOperation;
    private final MoveOperationBuilder moveOperationBuilder;
    private final CopyOperationBuilder copyOperationBuilder;
    private final ConceptLocationFactory conceptLocationFactory;

    @Inject
    public FileOperations(ViewContext viewContext, Set<FileStrategy> fileStrategies, ClipboardModelSource clipboardModelSource, IUSBFileOperation usbFileOperation, MoveOperationBuilder moveOperationBuilder, CopyOperationBuilder copyOperationBuilder, ConceptLocationFactory conceptLocationFactory) {
        this.clipboardModelSource = clipboardModelSource;
        this.viewContext = viewContext;
        this.fileStrategies = Collections.unmodifiableSet(fileStrategies);
        this.usbFileOperation = usbFileOperation;
        this.moveOperationBuilder = moveOperationBuilder;
        this.copyOperationBuilder = copyOperationBuilder;
        this.conceptLocationFactory = conceptLocationFactory;
    }

    public ClipboardOperationFactory getClipboardOperationFactory() {
        return new ClipboardOperationFactory(this.clipboardModelSource, this.moveOperationBuilder, this.copyOperationBuilder, this.conceptLocationFactory);
    }

    public RenameOperationFactory getRenameOperationFactory() {
        return new RenameOperationFactory(this.viewContext, this.fileStrategies, this.moveOperationBuilder, this.conceptLocationFactory);
    }

    public IUSBFileOperation getUSBFileOperation() {
        return this.usbFileOperation;
    }
}

