/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ErrorMessageProvider;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.polyscope.filemanager.impl.operations.FinalOperation;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;

public class OpenFinalOperation
implements FinalOperation {
    private final IFileChooser fileChooser;
    private final ViewContext viewContext;
    protected final FileManagerTextResource textResource;
    private final String[] extensions;

    public OpenFinalOperation(IFileChooser fileChooser, ViewContext viewContext, String[] extensions) {
        this.fileChooser = fileChooser;
        this.viewContext = viewContext;
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.extensions = (String[])extensions.clone();
    }

    public OpenFinalOperation(IFileChooser fileChooser, ViewContext viewContext) {
        this.fileChooser = fileChooser;
        this.viewContext = viewContext;
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.extensions = new String[]{""};
    }

    @Override
    public boolean execute(File selectedFile) {
        try {
            if (selectedFile.exists()) {
                if (!selectedFile.isDirectory()) {
                    this.fileChooser.getFinallySelectedFile().setFile(selectedFile);
                    this.fileChooser.getParentPanel().navigateBack();
                } else if (!this.fileChooser.isRestrictedAccess()) {
                    this.fileChooser.setCurrentDirectory(selectedFile);
                    this.fileChooser.rescan();
                }
            } else {
                String programName = ErrorMessageProvider.truncateFileNameIfNecessary(this.fileChooser.getSelectedFile().getName());
                this.viewContext.getDialogCreator().showErrorDialog(new ErrorMessage(this.textResource.Open(), this.textResource.fileDoesNotExist(HTML.convertToHtml((String)programName)), ""), new OkDialogListener());
            }
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean canExecute(File selectedFile) {
        String[] stringArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (selectedFile.getName().endsWith(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isFileTypeSpecified() {
        return !Arrays.asList(this.extensions).contains("");
    }

    @Override
    public AbstractFileSystemAction getFileAction() {
        AbstractFileSystemAction fileAction = new AbstractFileSystemAction(){

            public void actionPerformed(ActionEvent e) {
                OpenFinalOperation.this.execute(OpenFinalOperation.this.fileChooser.getSelectedFile());
            }
        };
        fileAction.putValue("Name", this.textResource.Open());
        fileAction.putValue("InternalName", "openFileButton.URFileChooser");
        return fileAction;
    }
}

