/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.disk.Directories;
import com.ur.polyscope.filemanager.impl.FileExtensions;
import com.ur.polyscope.filemanager.impl.operations.OperationRestriction;
import com.ur.polyscope.filemanager.impl.usb.USBDirectoryFilter;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;

public class OperationRestrictionImpl
implements OperationRestriction {
    private final USBDirectoryFilter usbDirectoryFilter;

    @Inject
    public OperationRestrictionImpl(USBDirectoryFilter usbDirectoryFilter) {
        this.usbDirectoryFilter = usbDirectoryFilter;
    }

    @Override
    public boolean isCutRestricted(File file, boolean isRestrictedAccess) {
        return isRestrictedAccess || file.isDirectory() || FileExtensions.isInstallation(file) || FileExtensions.isVariables(file);
    }

    @Override
    public boolean isNewDirectoryRestricted(boolean isRestrictedAccess) {
        return isRestrictedAccess;
    }

    @Override
    public boolean isCopyRestricted(File file, boolean isRestrictedAccess) {
        return isRestrictedAccess || file.isDirectory();
    }

    @Override
    public boolean isRenameRestricted(File file, boolean isRestrictedAccess) {
        return isRestrictedAccess || this.isProgramsFolder(file) || this.usbDirectoryFilter.isUSBDriveRoot(file) || FileExtensions.isInstallation(file) || FileExtensions.isVariables(file);
    }

    @Override
    public boolean isDeleteRestricted(File file, boolean isRestrictedAccess) {
        return isRestrictedAccess || this.isProgramsFolder(file) || this.usbDirectoryFilter.isUSBDriveRoot(file);
    }

    private boolean isProgramsFolder(File file) {
        boolean isPrograms = false;
        try {
            isPrograms = file != null && file.isDirectory() && Directories.programs().getCanonicalPath().equals(file.getCanonicalPath());
        }
        catch (IOException e) {
            Log.error((String)("Exception while getting canonical path" + e.getMessage()));
        }
        return isPrograms;
    }
}

