/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.concept.operations.ConceptOperation;
import com.ur.polyscope.concept.operations.MoveOperationBuilder;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.location.LocationType;
import com.ur.polyscope.concept.operations.location.Types;
import com.ur.polyscope.filemanager.FileStrategy;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ErrorMessageProvider;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.operations.DefaultFileStrategy;
import com.ur.swing.CompletedListener;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public class RenameOperation {
    private final IFileChooser fileChooser;
    private final ErrorMessageProvider errorMessageProvider;
    private final ErrorDialogCreator errorDialogCreator;
    private final Set<FileStrategy> fileStrategies;
    private final MoveOperationBuilder renameOperationBuilder;
    private final ConceptLocationFactory conceptLocationFactory;
    private final DefaultFileStrategy defaultFileStrategy;

    public RenameOperation(IFileChooser fileChooser, ViewContext viewContext, Set<FileStrategy> fileStrategies, MoveOperationBuilder renameOperationBuilder, ConceptLocationFactory conceptLocationFactory) {
        this.fileChooser = fileChooser;
        this.errorMessageProvider = new ErrorMessageProvider((FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class));
        this.errorDialogCreator = viewContext.getDialogCreator();
        this.fileStrategies = new HashSet<FileStrategy>(fileStrategies);
        this.renameOperationBuilder = renameOperationBuilder;
        this.conceptLocationFactory = conceptLocationFactory;
        this.defaultFileStrategy = new DefaultFileStrategy();
    }

    public void bindTextPicker(JComponent renameComponent) {
        TextFieldUtils.PositionHolder positionHolder = new TextFieldUtils.PositionHolder(){

            public int getPosition() {
                int pickerPosition = 0;
                int index = RenameOperation.this.fileChooser.getCurrentDirectoryList().getSelectedIndex();
                Rectangle bounds = RenameOperation.this.fileChooser.getCurrentDirectoryList().getCellBounds(index, index);
                if (bounds != null) {
                    Point p = new Point(bounds.x, bounds.y + bounds.height);
                    SwingUtilities.convertPointToScreen(p, RenameOperation.this.fileChooser.getCurrentDirectoryList());
                    pickerPosition = (int)p.getY();
                }
                return pickerPosition;
            }
        };
        ValidationStrategy fsNameValidator = ValidationFactory.getFileSystemNameValidator();
        RenameFileNameHolder renameFileNameHolder = new RenameFileNameHolder();
        TextFieldUtils.bindTextPickerAtPosition((JComponent)renameComponent, (TextFieldUtils.PositionHolder)positionHolder, (TextHolder)renameFileNameHolder, (CompletedListener)new RenamePickerCompletedListener(renameFileNameHolder), (ValidationStrategy)fsNameValidator);
    }

    private final class RenameFileNameHolder
    implements TextHolder {
        private File sourceFile;
        private String tempString;

        private RenameFileNameHolder() {
        }

        private File getSelectedFileToRename() {
            return this.sourceFile;
        }

        public String getText() {
            this.sourceFile = null;
            this.sourceFile = RenameOperation.this.fileChooser.getSelectedFile();
            this.tempString = this.sourceFile == null || !this.sourceFile.exists() ? "" : this.getDisplayName(this.sourceFile);
            return this.tempString;
        }

        public void setText(String text) {
            this.tempString = text;
        }

        private String getDisplayName(File file) {
            String originalName = file.getName();
            if (file.isDirectory()) {
                return originalName;
            }
            for (FileStrategy strategy : RenameOperation.this.fileStrategies) {
                if (!strategy.isSupported(originalName)) continue;
                return strategy.getInputDisplayName(originalName);
            }
            return RenameOperation.this.defaultFileStrategy.getInputDisplayName(originalName);
        }
    }

    private final class RenamePickerCompletedListener
    implements CompletedListener {
        private final RenameFileNameHolder renameFileNameHolder;

        private RenamePickerCompletedListener(RenameFileNameHolder renameFileNameHolder) {
            this.renameFileNameHolder = renameFileNameHolder;
        }

        private boolean renameDirectory(File sourceDirectory, File destinationDirectory) {
            boolean isRenamed;
            if (destinationDirectory.exists()) {
                RenameOperation.this.errorDialogCreator.showErrorDialog(RenameOperation.this.errorMessageProvider.errorInDirectoryRename(), new OkDialogListener());
                isRenamed = false;
            } else {
                if (!sourceDirectory.renameTo(destinationDirectory)) {
                    Log.error((String)"Could not rename directory");
                }
                isRenamed = destinationDirectory.exists();
            }
            return isRenamed;
        }

        private void renameFileByStrategy(File sourceFile, File destinationFile) {
            for (FileStrategy fileStrategy : RenameOperation.this.fileStrategies) {
                if (!fileStrategy.isSupported(sourceFile.getName())) continue;
                fileStrategy.renameFile(sourceFile, destinationFile);
                return;
            }
            RenameOperation.this.defaultFileStrategy.renameFile(sourceFile, destinationFile);
        }

        private boolean destinationFileExists(File sourceFile, File destinationFile) {
            String extension = FileUtils.getExtension((File)sourceFile);
            if (!extension.equals(FileUtils.getExtension((File)destinationFile))) {
                destinationFile = new File(String.valueOf(destinationFile.getAbsolutePath()) + "." + extension);
            }
            return destinationFile.exists();
        }

        private boolean renameFile(File sourceFile, File destinationFile) {
            boolean isRenamed;
            if (this.destinationFileExists(sourceFile, destinationFile)) {
                RenameOperation.this.errorDialogCreator.showErrorDialog(RenameOperation.this.errorMessageProvider.errorInFileRename(), new OkDialogListener());
                isRenamed = false;
            } else {
                this.renameFileByStrategy(sourceFile, destinationFile);
                isRenamed = !sourceFile.exists();
            }
            return isRenamed;
        }

        private boolean rename(File source, File destinationFile) {
            boolean isRenamed = source.exists() && source.isDirectory() ? this.renameDirectory(source, destinationFile) : this.renameFile(source, destinationFile);
            return isRenamed;
        }

        private boolean performNormalRename(File source, String destinationName) {
            boolean isRenamed = false;
            if (!destinationName.equals(source.getName())) {
                File destinationFile = new File(RenameOperation.this.fileChooser.getCurrentDirectory(), destinationName);
                isRenamed = this.rename(source, destinationFile);
            }
            return isRenamed;
        }

        private boolean performConceptRename(File sourceFile, String destinationName, LocationType type) {
            File sourceDirectory = sourceFile.getParentFile();
            ConceptLocation originalLocation = RenameOperation.this.conceptLocationFactory.get(FilenameUtils.removeExtension((String)sourceFile.getName()), sourceDirectory.getPath(), type);
            ConceptLocation newLocation = RenameOperation.this.conceptLocationFactory.get(FilenameUtils.removeExtension((String)destinationName), sourceDirectory.getPath(), type);
            boolean canExecuteAll = true;
            final List conceptOperations = RenameOperation.this.renameOperationBuilder.buildRename(originalLocation, newLocation);
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (ConceptOperation conceptOperation : conceptOperations) {
                if (conceptOperation.canExecute()) continue;
                RenameOperation.this.errorDialogCreator.showErrorDialog(RenameOperation.this.errorMessageProvider.errorInFileRename(), new OkDialogListener());
                canExecuteAll = false;
                errorMessages.add(conceptOperation.getError());
            }
            if (canExecuteAll) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (ConceptOperation conceptOperation : conceptOperations) {
                            conceptOperation.execute();
                        }
                        SwingUtil.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                RenameOperation.this.fileChooser.updateUIFields();
                            }
                        });
                    }
                }).start();
                return true;
            }
            for (String errorMessage : errorMessages) {
                Log.error((String)errorMessage);
            }
            return false;
        }

        private boolean performRename(File source, String destinationName) {
            if (FilenameUtils.removeExtension((String)source.getName()).equals(destinationName)) {
                return false;
            }
            LocationType type = this.getType(source);
            if (type == null || !RenameOperation.this.conceptLocationFactory.get(destinationName, source.getPath(), type).isValid()) {
                return this.performNormalRename(source, destinationName);
            }
            return this.performConceptRename(source, destinationName, type);
        }

        private LocationType getType(File file) {
            String extension = FileUtils.getExtension((File)file);
            if (extension != null) {
                if (extension.equals("urp")) {
                    return Types.getProgram();
                }
                if (extension.equals("installation")) {
                    return Types.getInstallation();
                }
            }
            return null;
        }

        public void requestApply() {
            String destinationName;
            File source = this.renameFileNameHolder.getSelectedFileToRename();
            if (this.performRename(source, destinationName = this.renameFileNameHolder.tempString)) {
                RenameOperation.this.fileChooser.updateUIFields();
            }
        }

        public void requestCancel() {
        }
    }
}

