/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ConfirmationMessageProvider;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.polyscope.filemanager.impl.operations.FinalOperation;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.util.logging.Log;
import java.awt.event.ActionEvent;
import java.io.File;

public class SaveFinalOperation
implements FinalOperation {
    private final IFileChooser fileChooser;
    private final ConfirmationDialogCreator dialogCreator;
    private final ConfirmationMessageProvider messageProvider;
    protected final FileManagerTextResource textResource;
    private String extension;

    public SaveFinalOperation(IFileChooser fileChooser, ViewContext viewContext) {
        this(fileChooser, viewContext, "");
    }

    public SaveFinalOperation(IFileChooser fileChooser, ViewContext viewContext, String extension) {
        this.fileChooser = fileChooser;
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.extension = extension;
        this.dialogCreator = viewContext.getDialogCreator();
        this.messageProvider = new ConfirmationMessageProvider(this.textResource);
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public boolean execute(File selectedFile) {
        File finalFile;
        block10: {
            try {
                File file = finalFile = this.canExecute(selectedFile) || selectedFile.isDirectory() ? selectedFile : new File(String.valueOf(selectedFile.getPath()) + this.extension);
                if (!finalFile.getName().contains(this.textResource.placeholderUnnamed())) break block10;
                this.fileChooser.getFinallySelectedFile().setFile(null);
                return true;
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
                return false;
            }
        }
        if (finalFile.exists()) {
            if (finalFile.isDirectory() && this.fileChooser.isDirectoryEndpoint()) {
                this.fileChooser.setCurrentDirectory(finalFile);
                this.fileChooser.getFinallySelectedFile().setFile(finalFile);
                this.fileChooser.getParentPanel().navigateBack();
            } else if (!finalFile.isDirectory()) {
                this.dialogCreator.showConfirmationDialog(this.messageProvider.confirmOverwriteFile(finalFile.getName()), new ConfirmationDialogListener(){

                    public void onOkClicked() {
                        SaveFinalOperation.this.fileChooser.getFinallySelectedFile().setFile(finalFile);
                        SaveFinalOperation.this.fileChooser.getParentPanel().navigateBack();
                    }
                });
            } else if (!this.fileChooser.isRestrictedAccess()) {
                this.fileChooser.setCurrentDirectory(finalFile);
                this.fileChooser.rescan();
            }
        } else {
            this.fileChooser.getFinallySelectedFile().setFile(finalFile);
            this.fileChooser.getParentPanel().navigateBack();
        }
        return true;
    }

    @Override
    public boolean canExecute(File selectedFile) {
        return selectedFile.getName().endsWith(this.extension);
    }

    @Override
    public boolean isFileTypeSpecified() {
        return !this.extension.isEmpty();
    }

    @Override
    public AbstractFileSystemAction getFileAction() {
        AbstractFileSystemAction fileAction = new AbstractFileSystemAction(){

            public void actionPerformed(ActionEvent e) {
                SaveFinalOperation.this.execute(SaveFinalOperation.this.fileChooser.getSelectedFile());
            }
        };
        if (this.fileChooser.isDirectoryEndpoint()) {
            fileAction.putValue("Name", this.textResource.Select());
        } else {
            fileAction.putValue("Name", this.textResource.Save());
        }
        fileAction.putValue("InternalName", "saveFileButton.URFileChooser");
        return fileAction;
    }
}

