/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.filemanager.SwingFileRenderer;
import com.ur.polyscope.filemanager.impl.SharedImageResource;
import com.ur.polyscope.filemanager.impl.SharedStyleResource;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.inject.Inject;
import javax.swing.BorderFactory;

public class VariablesFileRenderer
extends SwingFileRenderer.Template {
    private SharedImageResource imageResource;
    private SharedStyleResource styleResource;

    @Inject
    VariablesFileRenderer(SharedImageResource imageResource, SharedStyleResource styleResource) {
        this.imageResource = imageResource;
        this.styleResource = styleResource;
    }

    public Component render(File file, boolean isSelected, boolean cellHasFocus) {
        Color focusColor = isSelected ? this.styleResource.focusColor() : this.styleResource.unfocusColor();
        this.setBorder(BorderFactory.createLineBorder(focusColor, 3));
        this.setBackground(cellHasFocus ? focusColor : this.styleResource.unfocusColor());
        this.setFont(this.getFont().deriveFont(this.styleResource.fileFontStyle()));
        this.setForeground(this.styleResource.fileColor());
        this.setIcon(this.imageResource.variablesFile());
        this.setText(file.getName());
        return this;
    }
}

