/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.usb;

import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ErrorMessageProvider;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.SharedImageResource;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.polyscope.filemanager.impl.usb.IUSBFileOperation;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.swing.JProgressBar;

public class BackupToUSBAction
extends AbstractFileSystemAction {
    private final IFileChooser fileChooser;
    private final FileManagerTextResource textResource;
    private final ErrorMessageProvider errorMessageProvider;
    private final ErrorDialogCreator errorDialogCreator;
    private final IUSBFileOperation usbFileOperation;
    private FileCopyWrapper fileCopyWrapper = new FileCopyWrapper();

    public BackupToUSBAction(IFileChooser fileChooser, ViewContext viewContext, SharedImageResource sharedImageResource, IUSBFileOperation usbFileOperation) {
        this.fileChooser = fileChooser;
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.errorMessageProvider = new ErrorMessageProvider(this.textResource);
        this.errorDialogCreator = viewContext.getDialogCreator();
        this.usbFileOperation = usbFileOperation;
        this.putValue("Name", this.textResource.BACKUP());
        this.putValue("SmallIcon", sharedImageResource.usb());
        this.putValue("InternalName", "backUpToUsb.URFileChooser");
    }

    public BackupToUSBAction(IFileChooser fileChooser, JProgressBar progressBar, ViewContext viewContext, SharedImageResource sharedImageResource, IUSBFileOperation usbFileOperation) {
        this(fileChooser, viewContext, sharedImageResource, usbFileOperation);
        this.fileCopyWrapper = new FileCopyWrapperProgressBar(progressBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.usbFileOperation.isUsbPresent()) {
            this.errorDialogCreator.showErrorDialog(this.errorMessageProvider.usbDriveNotFound(), new OkDialogListener());
            return;
        }
        this.fileCopyWrapper.copyFile(this.fileChooser.getCurrentDirectory());
    }

    private class FileCopyWrapper {
        private FileCopyWrapper() {
        }

        public void copyFile(File source) {
            Runnable copyBackground = () -> {
                try {
                    this.beforeCopy();
                    BackupToUSBAction.this.usbFileOperation.copyToUSB(source);
                    this.afterCopy();
                }
                catch (IOException e) {
                    this.createErrorDialog(e.toString());
                    Log.error((String)"Failed to backup to USB", (Throwable)e);
                }
            };
            new Thread(copyBackground).start();
        }

        protected void beforeCopy() {
            SwingUtil.invokeLater(() -> BackupToUSBAction.this.setEnabled(false));
        }

        protected void afterCopy() {
            SwingUtil.invokeLater(() -> BackupToUSBAction.this.setEnabled(true));
        }

        protected void createErrorDialog(String msg) {
            SwingUtil.invokeLater(() -> BackupToUSBAction.this.errorDialogCreator.showErrorDialog(BackupToUSBAction.this.errorMessageProvider.failuretoBackupToUsb(msg), new OkDialogListener()));
        }

        /* synthetic */ FileCopyWrapper(FileCopyWrapper fileCopyWrapper, FileCopyWrapper fileCopyWrapper2) {
            this();
        }
    }

    private class FileCopyWrapperProgressBar
    extends FileCopyWrapper {
        private final JProgressBar progressBar;

        public FileCopyWrapperProgressBar(JProgressBar progressBar) {
            super(null, null);
            this.progressBar = progressBar;
        }

        @Override
        public void copyFile(File source) {
            Runnable copyBackground = () -> {
                try {
                    this.beforeCopy();
                    BackupToUSBAction.this.usbFileOperation.copyToUSB(source);
                    Waiting.pause((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    this.afterCopy();
                }
                catch (IOException e) {
                    this.createErrorDialog(e.toString());
                    Log.error((String)"Failed to backup to USB", (Throwable)e);
                }
            };
            new Thread(copyBackground).start();
        }

        @Override
        protected void beforeCopy() {
            SwingUtil.invokeLater(() -> {
                this.progressBar.setIndeterminate(true);
                this.progressBar.setVisible(true);
                BackupToUSBAction.this.setEnabled(false);
            });
        }

        @Override
        protected void afterCopy() {
            SwingUtil.invokeLater(() -> {
                BackupToUSBAction.this.setEnabled(true);
                this.progressBar.setVisible(false);
            });
        }
    }
}

