/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.usb;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ConfirmationMessageProvider;
import com.ur.polyscope.filemanager.impl.ErrorMessageProvider;
import com.ur.polyscope.filemanager.impl.usb.IUSBFileOperation;
import com.ur.polyscope.filemanager.impl.usb.USBActionModelSource;
import com.ur.polyscope.filemanager.impl.usb.USBState;
import com.ur.swing.JFrameUtils;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.Optional;
import com.ur.util.logging.Log;
import java.awt.Cursor;
import javax.inject.Inject;
import javax.swing.JFrame;

@ReadOnlyDashboardAction
public class PerformUSBActionModelSource
implements DashBoardAction {
    public static final ScriptActionDefinitionParser USB_INSERTED = new ScriptActionDefinitionParser("usb inserted");
    public static final ScriptActionDefinitionParser USB_REMOVED = new ScriptActionDefinitionParser("usb removed");
    public static final ScriptActionDefinitionParser USB_UNKNOWN_FS = new ScriptActionDefinitionParser("usb unknown fs <arg>");
    private final FileManagerTextResource textResource;
    private final ConfirmationMessageProvider confirmationMessageProvider;
    private final ErrorMessageProvider errorMessageProvider;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final ErrorDialogCreator errorDialogCreator;
    private final MessageDialogCreator messageDialogCreator;
    private final USBActionModelSource usbActionModelSource;
    private final IUSBFileOperation usbFileOperation;

    @Inject
    public PerformUSBActionModelSource(ViewContext viewContext, USBActionModelSource usbActionModelSource, IUSBFileOperation usbFileOperation) {
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.confirmationMessageProvider = new ConfirmationMessageProvider(this.textResource);
        this.errorMessageProvider = new ErrorMessageProvider(this.textResource);
        this.confirmationDialogCreator = viewContext.getDialogCreator();
        this.errorDialogCreator = viewContext.getDialogCreator();
        this.messageDialogCreator = viewContext.getDialogCreator();
        this.usbActionModelSource = usbActionModelSource;
        this.usbFileOperation = usbFileOperation;
        boolean usbPresent = usbFileOperation.isUsbPresent();
        usbActionModelSource.emit(new USBState(usbPresent));
    }

    public boolean canHandleMessage(String input) {
        return USB_INSERTED.isMatch(input) || USB_REMOVED.isMatch(input) || USB_UNKNOWN_FS.isMatch(input);
    }

    public String execute(final String inputLine) {
        if (USB_INSERTED.isMatch(inputLine)) {
            this.usbActionModelSource.emit(new USBState(true));
            return "usb inserted event received";
        }
        if (USB_REMOVED.isMatch(inputLine)) {
            this.usbActionModelSource.emit(new USBState(false));
            return "usb removed event received";
        }
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PerformUSBActionModelSource.this.formatFileSystem(inputLine);
            }
        });
        return "usb unknown fs event received";
    }

    private void formatFileSystem(String inputLine) {
        this.confirmationDialogCreator.showConfirmationDialog(this.confirmationMessageProvider.confirmFormatUsbDrive(), (ConfirmationDialogListener)new FormatDialogListener(inputLine, this.usbFileOperation));
    }

    private class FormatDialogListener
    extends ConfirmationDialogListener {
        private String inputLine;
        private IUSBFileOperation usbFileOperation;

        public FormatDialogListener(String inputLine, IUSBFileOperation usbFileOperation) {
            this.inputLine = inputLine;
            this.usbFileOperation = usbFileOperation;
        }

        public void onOkClicked() {
            block9: {
                Optional frame = JFrameUtils.getParentFrame();
                try {
                    try {
                        String argument;
                        boolean formatted;
                        if (frame.isPresent()) {
                            ((JFrame)frame.get()).setCursor(Cursor.getPredefinedCursor(3));
                        }
                        if (formatted = this.usbFileOperation.formatFileSystem(argument = USB_UNKNOWN_FS.getArgument(0, this.inputLine))) {
                            PerformUSBActionModelSource.this.messageDialogCreator.showMessageDialog(new DialogMessage("usb formatted", PerformUSBActionModelSource.this.textResource.formatUsbDone()), MessageDialogType.MESSAGE, new OkDialogListener());
                            break block9;
                        }
                        PerformUSBActionModelSource.this.errorDialogCreator.showErrorDialog(PerformUSBActionModelSource.this.errorMessageProvider.failedToFormatUsb(), new OkDialogListener());
                    }
                    catch (Exception e) {
                        PerformUSBActionModelSource.this.errorDialogCreator.showErrorDialog(PerformUSBActionModelSource.this.errorMessageProvider.failedToFormatUsb(), new OkDialogListener());
                        Log.error((String)"DashBoardServer.processInput() Error6: Could not execute usbplug.sh format script: ", (Throwable)e);
                        if (frame.isPresent()) {
                            ((JFrame)frame.get()).setCursor(Cursor.getDefaultCursor());
                        }
                        PerformUSBActionModelSource.this.usbActionModelSource.emit(new USBState(true));
                    }
                }
                finally {
                    if (frame.isPresent()) {
                        ((JFrame)frame.get()).setCursor(Cursor.getDefaultCursor());
                    }
                    PerformUSBActionModelSource.this.usbActionModelSource.emit(new USBState(true));
                }
            }
        }
    }
}

