/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.usb;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.filemanager.UsbStateListener;
import com.ur.polyscope.filemanager.impl.usb.USBState;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;

public class USBActionListener {
    private final Recipe<USBState> usbStateRecipe;

    @Inject
    public USBActionListener(@Source(value=USBState.class) Recipe<USBState> usbStateRecipe) {
        this.usbStateRecipe = usbStateRecipe;
        this.usbStateRecipe.executeOnUIThread().subscribe((Consumer)new Consumer<USBState>(){

            public void accept(USBState usbState) {
                if (usbState.isPresent()) {
                    USBActionListener.this.notifyUsbInsertedEvent();
                } else {
                    USBActionListener.this.notifyUsbRemovedEvent();
                }
            }
        });
    }

    private void notifyUsbInsertedEvent() {
        EventNotificationService.notify(UsbStateListener.class, (NotificationStrategy)new NotificationStrategy<UsbStateListener>(){

            public void notify(UsbStateListener listener) {
                listener.usbInserted();
            }
        });
    }

    private void notifyUsbRemovedEvent() {
        EventNotificationService.notify(UsbStateListener.class, (NotificationStrategy)new NotificationStrategy<UsbStateListener>(){

            public void notify(UsbStateListener listener) {
                listener.usbRemoved();
            }
        });
    }
}

