/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.usb;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.polyscope.filemanager.impl.actions.FileSystemActionFactory;
import com.ur.polyscope.filemanager.impl.usb.IUSBFileOperation;
import com.ur.polyscope.filemanager.impl.usb.USBState;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.plaf.metal.MetalButtonUI;

public class USBBackupIndicator
extends JPanel {
    private final IFileChooser fileChooser;
    private final WidgetFactory widgetFactory;
    private final FileSystemActionFactory fileSystemActionFactory;
    private final IUSBFileOperation usbFileOperation;
    private final Recipe<USBState> usbStateRecipe;
    private JButton usbButton;
    private JProgressBar progressBar;

    public USBBackupIndicator(IFileChooser fileChooser, ViewContext viewContext, FileSystemActionFactory fileSystemActionFactory, @Source(value=USBState.class) Recipe<USBState> usbStateRecipe, IUSBFileOperation usbFileOperation) {
        this.fileChooser = fileChooser;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.fileSystemActionFactory = fileSystemActionFactory;
        this.usbStateRecipe = usbStateRecipe;
        this.usbFileOperation = usbFileOperation;
        this.initComponents();
    }

    private boolean checkUnrestrictedAccess(boolean isUSBPresent) {
        return isUSBPresent && !this.fileChooser.isRestrictedAccess();
    }

    public void checkForUSB() {
        this.usbButton.setEnabled(this.checkUnrestrictedAccess(this.usbFileOperation.isUsbPresent()));
    }

    private void initComponents() {
        this.buildProgressBar();
        this.buildButton();
        this.subscribeUSBAction();
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcBase = new GridBagConstraints();
        gbcBase.gridx = 0;
        gbcBase.gridy = 0;
        gbcBase.weightx = 1.0;
        gbcBase.weighty = 1.0;
        gbcBase.fill = 0;
        GridBagConstraints gbcProgress = (GridBagConstraints)gbcBase.clone();
        gbcProgress.insets = new Insets(0, 0, -13, 0);
        this.add((Component)this.progressBar, gbcProgress);
        GridBagConstraints gbcButton = (GridBagConstraints)gbcBase.clone();
        this.add((Component)this.usbButton, gbcButton);
        Dimension usbSize = this.usbButton.getPreferredSize();
        this.setMinimumSize(usbSize);
        this.setMaximumSize(usbSize);
        this.setPreferredSize(usbSize);
    }

    private void buildButton() {
        AbstractFileSystemAction backupAction = this.fileSystemActionFactory.getBackupToUSBAction(this.fileChooser, this.progressBar);
        backupAction.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
        this.usbButton = this.widgetFactory.createButton((Action)((Object)backupAction));
        Dimension dimBtn = backupAction.getRecommendedDimension(this.usbButton.getFont());
        this.usbButton.setForeground(Color.black);
        this.usbButton.setBackground(Color.WHITE);
        this.usbButton.setMaximumSize(dimBtn);
        this.usbButton.setMinimumSize(dimBtn);
        this.usbButton.setPreferredSize(dimBtn);
        this.usbButton.setUI(new FileButtonLookAndFeel());
    }

    private void buildProgressBar() {
        Dimension dimProgressBar = new Dimension(48, 12);
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximumSize(dimProgressBar);
        this.progressBar.setMinimumSize(dimProgressBar);
        this.progressBar.setPreferredSize(dimProgressBar);
        this.progressBar.setVisible(false);
    }

    private void subscribeUSBAction() {
        this.usbStateRecipe.executeOnUIThread().distinctUntilChanged().subscribe((Consumer)new Consumer<USBState>(){

            public void accept(USBState usbState) {
                USBBackupIndicator.this.usbButton.setEnabled(USBBackupIndicator.this.checkUnrestrictedAccess(usbState.isPresent()));
            }
        });
    }

    private static final class FileButtonLookAndFeel
    extends MetalButtonUI {
        private FileButtonLookAndFeel() {
        }

        @Override
        protected Color getSelectColor() {
            return G5LookAndFeel.DISABLED_BACKGROUND;
        }
    }
}

