/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.usb;

import com.ur.lang.StringUtils;
import com.ur.polyscope.filemanager.impl.usb.USBDirectoryFilter;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class USBDirectoryFilterImpl
implements USBDirectoryFilter {
    private static final String LOG_IO_EXCEPTION = "Exception caught, trying to decide if file is a symlink";

    @Override
    public boolean isUSBDriveRoot(File file) {
        try {
            String canonicalFilePath = file.getCanonicalPath();
            int depth = StringUtils.numberOfOccurances((String)File.separator, (String)file.getAbsolutePath());
            return canonicalFilePath.startsWith("/media") && depth == 2;
        }
        catch (IOException e) {
            Log.error((String)LOG_IO_EXCEPTION, (Throwable)e);
            return false;
        }
    }

    @Override
    public String getRootName(File file) {
        try {
            String canonicalFilePath = file.getCanonicalPath();
            Pattern pattern = Pattern.compile("/media/(.*?)/");
            Matcher matcher = pattern.matcher(canonicalFilePath);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (IOException e) {
            Log.error((String)LOG_IO_EXCEPTION, (Throwable)e);
        }
        return "";
    }

    @Override
    public boolean isPathOnUSB(File file) {
        try {
            String canonicalFilePath = file.getCanonicalPath();
            return canonicalFilePath.startsWith("/media");
        }
        catch (IOException e) {
            Log.error((String)LOG_IO_EXCEPTION, (Throwable)e);
            return false;
        }
    }
}

