/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.usb;

import com.ur.polyscope.filemanager.impl.usb.IUSBFileOperation;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;

public class USBFileOperationImpl
implements IUSBFileOperation {
    private final File root;
    private static final String MEDIA_ROOT = "/media";

    public USBFileOperationImpl() {
        this.root = new File(MEDIA_ROOT);
    }

    public USBFileOperationImpl(File root) {
        this.root = root;
    }

    private File findUsbDiskFile() {
        File[] listOfFiles = this.root.listFiles();
        if (listOfFiles != null) {
            File[] fileArray = listOfFiles;
            int n = listOfFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && !f.isHidden() && f.canWrite()) {
                    return f;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public boolean isUsbPresent() {
        return this.findUsbDiskFile() != null;
    }

    @Override
    public void copyToUSB(File source) throws IOException {
        File dest = this.findUsbDiskFile();
        FileUtils.copyDir((File)source, (File)dest);
    }

    @Override
    public boolean formatFileSystem(String argument) throws IOException {
        BashScriptRunner bs = new BashScriptRunner("/root/usbplug.sh format " + argument);
        bs.execute();
        return bs.getReturnVal() == 0;
    }
}

