/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.resources;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            ImageResource.tryGetImage("urcapx-file.png");
            ImageResource.tryGetImage("rename.png");
            ImageResource.tryGetImage("seperator.png");
            ImageResource.tryGetImage("variables-file.png");
            ImageResource.tryGetImage("gnome-fs-regular.png");
            ImageResource.tryGetImage("script-file.png");
            ImageResource.tryGetImage("go-home.png");
            ImageResource.tryGetImage("usb.png");
            ImageResource.tryGetImage("go-up.png");
            ImageResource.tryGetImage("file-modify.png");
            ImageResource.tryGetImage("cut.png");
            ImageResource.tryGetImage("installation-file.png");
            ImageResource.tryGetImage("arrow_left.png");
            ImageResource.tryGetImage("folder-new.png");
            ImageResource.tryGetImage("copy.png");
            ImageResource.tryGetImage("Paste.png");
            ImageResource.tryGetImage("urp-file.png");
            ImageResource.tryGetImage("delete.png");
            ImageResource.tryGetImage("folder.png");
            ImageResource.tryGetImage("urcap-file.png");
            ImageResource.tryGetImage("arrow_right.png");
        }
    }

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="urcapx-file.png")
    public static @Key(value="urcapx-file.png") Icon urcapxFile() {
        return ImageResource.tryGetImage("urcapx-file.png");
    }

    @Key(value="rename.png")
    public static @Key(value="rename.png") Icon rename() {
        return ImageResource.tryGetImage("rename.png");
    }

    @Key(value="seperator.png")
    public static @Key(value="seperator.png") Icon seperator() {
        return ImageResource.tryGetImage("seperator.png");
    }

    @Key(value="variables-file.png")
    public static @Key(value="variables-file.png") Icon variablesFile() {
        return ImageResource.tryGetImage("variables-file.png");
    }

    @Key(value="gnome-fs-regular.png")
    public static @Key(value="gnome-fs-regular.png") Icon gnomeFsRegular() {
        return ImageResource.tryGetImage("gnome-fs-regular.png");
    }

    @Key(value="script-file.png")
    public static @Key(value="script-file.png") Icon scriptFile() {
        return ImageResource.tryGetImage("script-file.png");
    }

    @Key(value="go-home.png")
    public static @Key(value="go-home.png") Icon goHome() {
        return ImageResource.tryGetImage("go-home.png");
    }

    @Key(value="usb.png")
    public static @Key(value="usb.png") Icon usb() {
        return ImageResource.tryGetImage("usb.png");
    }

    @Key(value="go-up.png")
    public static @Key(value="go-up.png") Icon goUp() {
        return ImageResource.tryGetImage("go-up.png");
    }

    @Key(value="file-modify.png")
    public static @Key(value="file-modify.png") Icon fileModify() {
        return ImageResource.tryGetImage("file-modify.png");
    }

    @Key(value="cut.png")
    public static @Key(value="cut.png") Icon cut() {
        return ImageResource.tryGetImage("cut.png");
    }

    @Key(value="installation-file.png")
    public static @Key(value="installation-file.png") Icon installationFile() {
        return ImageResource.tryGetImage("installation-file.png");
    }

    @Key(value="arrow_left.png")
    public static @Key(value="arrow_left.png") Icon arrowLeft() {
        return ImageResource.tryGetImage("arrow_left.png");
    }

    @Key(value="folder-new.png")
    public static @Key(value="folder-new.png") Icon folderNew() {
        return ImageResource.tryGetImage("folder-new.png");
    }

    @Key(value="copy.png")
    public static @Key(value="copy.png") Icon copy() {
        return ImageResource.tryGetImage("copy.png");
    }

    @Key(value="Paste.png")
    public static @Key(value="Paste.png") Icon Paste() {
        return ImageResource.tryGetImage("Paste.png");
    }

    @Key(value="urp-file.png")
    public static @Key(value="urp-file.png") Icon urpFile() {
        return ImageResource.tryGetImage("urp-file.png");
    }

    @Key(value="delete.png")
    public static @Key(value="delete.png") Icon delete() {
        return ImageResource.tryGetImage("delete.png");
    }

    @Key(value="folder.png")
    public static @Key(value="folder.png") Icon folder() {
        return ImageResource.tryGetImage("folder.png");
    }

    @Key(value="urcap-file.png")
    public static @Key(value="urcap-file.png") Icon urcapFile() {
        return ImageResource.tryGetImage("urcap-file.png");
    }

    @Key(value="arrow_right.png")
    public static @Key(value="arrow_right.png") Icon arrowRight() {
        return ImageResource.tryGetImage("arrow_right.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

